# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Upload a font scheme
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# URL to the SharePoint site
$webUrl = "http://sharepoint/site"

# Path to the font scheme file
$filePath = "c:\temp\myfonts.spfont"

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Get the SharePoint site
$web = Get-SPWeb $webUrl

# Get the _catalogs/theme/15 folder
$themeFolder = $web.Folders["_catalogs"].Subfolders["theme"].Subfolders["15"]

# Get the file name from the path
$fileName = [System.IO.Path]::GetFileName($filePath)

# Get the contents of the font scheme file
$fileStream = [System.IO.File]::OpenRead($filePath)

# Add the file to the folder
$themeFolder.Files.Add($fileName, $fileStream, $true)

# Update the folder
$themeFolder.Update()

# Dispose of the site object
$web.Dispose()

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 